#include "currency_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>

#include <library/cpp/logger/global/global.h>

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TCurrencySelectQuery::TCurrencySelectQuery()
            : TSelectQuery("currency_currency", false)
            , IdField(AddField("id"))
            , CodeField(AddField("code"))
            , IsoCodeField(AddField("iso_code"))
            , OrderField(AddField("`order`"))
            , OrderTrField(AddField("order_tr"))
            , OrderUaField(AddField("order_ua"))
            , NameField(AddField("name"))
            , NameInField(AddField("name_in"))
            , NameTrField(AddField("name_tr"))
            , NameUkField(AddField("name_uk"))
            , NameUkInField(AddField("name_uk_in"))
            , TemplateField(AddField("template"))
            , TemplateWholeField(AddField("template_whole"))
            , TemplateCentsField(AddField("template_cents"))
            , TemplateTrField(AddField("template_tr"))
            , TemplateWholeTrField(AddField("template_whole_tr"))
            , TemplateCentsTrField(AddField("template_cents_tr"))
        {
        }

        TCurrencyDumper::TCurrencyDumper(IFetcher& fetcher,
                                         IObjectWriter<TCurrency>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TMap<TString, i32> TCurrencyDumper::Dump() {
            INFO_LOG << "Run the currency dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TMap<TString, i32> codeToId;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TCurrency record;
                auto id = ParseId(row[Query.IdField]);
                auto code = row[Query.CodeField];

                record.SetId(id);
                record.SetCode(code);
                record.SetIsoCode(row[Query.IsoCodeField]);
                record.SetOrder(ParseI32(row[Query.OrderField]));
                record.SetOrderTr(ParseI32(row[Query.OrderTrField]));
                record.SetOrderUa(ParseI32(row[Query.OrderUaField]));

                record.MutableTitle()->SetRu(row[Query.NameField]);
                record.MutableTitle()->SetTr(row[Query.NameTrField]);
                record.MutableTitle()->SetUk(row[Query.NameUkField]);

                record.MutableTitleIn()->SetRu(row[Query.NameInField]);
                record.MutableTitleIn()->SetUk(row[Query.NameUkInField]);

                record.MutableTemplate()->SetRu(row[Query.TemplateField]);
                record.MutableTemplate()->SetTr(row[Query.TemplateTrField]);

                record.MutableTemplateWhole()->SetRu(row[Query.TemplateWholeField]);
                record.MutableTemplateWhole()->SetTr(row[Query.TemplateWholeTrField]);

                record.MutableTemplateCents()->SetRu(row[Query.TemplateCentsField]);
                record.MutableTemplateCents()->SetTr(row[Query.TemplateCentsTrField]);

                codeToId[code] = id;

                Writer_.Write(record);
            };

            if (codeToId.empty()){
                ythrow yexception() << "Currency dumper has no records.";
            }
            INFO_LOG << "The currency dumper has dumped: total count of currencies is " << codeToId.size() << Endl;

            return codeToId;
        }
    }
}
