#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/currency.pb.h>

#include <util/generic/map.h>

namespace NRasp {
    namespace NDumper {
        class TCurrencySelectQuery: public TSelectQuery {
        public:
            TCurrencySelectQuery();

        public:
            const i32 IdField;
            const i32 CodeField;
            const i32 IsoCodeField;
            const i32 OrderField;
            const i32 OrderTrField;
            const i32 OrderUaField;
            const i32 NameField;
            const i32 NameInField;
            const i32 NameTrField;
            const i32 NameUkField;
            const i32 NameUkInField;
            const i32 TemplateField;
            const i32 TemplateWholeField;
            const i32 TemplateCentsField;
            const i32 TemplateTrField;
            const i32 TemplateWholeTrField;
            const i32 TemplateCentsTrField;            
        };

        class TCurrencyDumper {
        public:
            TCurrencyDumper(NRasp::NDumper::IFetcher& fetcher,
                            IObjectWriter<NData::TCurrency>& writer);
            TMap<TString, i32> Dump();

        public:
            const TCurrencySelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TCurrency>& Writer_;
        };
    }
}
