#include "currency_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/string/cast.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TCurrencyDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TCurrencyDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TCurrency> ObjectWriter_;
    THolder<TCurrencyDumper> Dumper_;

    TString RubCode;
    i32 RubId;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TCurrency>();

        Dumper_ = MakeHolder<TCurrencyDumper>(Fetcher_, ObjectWriter_);
        RubCode = "RUB";
        RubId = 123;
    }

    TVector<TString> CreateRow() {
        return {
            ToString(RubId),     // id
            RubCode,             // code
            "RUB",               // iso_code
            ToString(1),         // order
            ToString(3),         // order_tr
            ToString(0),         // order_ua
            "рубли",             // name
            "в рублях",          // name_in
            "Ruble",             // name_tr
            "рублі",             // name_uk
            "у рублях",          // name_uk_in
            "template",          // template
            "template_whole",    // template_whole
            "template_cents",    // template_cents
            "template_tr",       // template_tr
            "template_whole_tr", // template_whole_tr
            "template_cents_tr", // template_cents_tr
        };
    }
    TCurrency CreateModel() {
        TCurrency s;

        s.SetId(RubId);
        s.SetCode(RubCode);
        s.SetIsoCode("RUB");
        s.SetOrder(1);
        s.SetOrderTr(3);
        s.SetOrderUa(0);
        s.MutableTitle()->SetRu("рубли");
        s.MutableTitleIn()->SetRu("в рублях");
        s.MutableTitle()->SetTr("Ruble");
        s.MutableTitle()->SetUk("рублі");
        s.MutableTitleIn()->SetUk("у рублях");
        s.MutableTemplate()->SetRu("template");
        s.MutableTemplateWhole()->SetRu("template_whole");
        s.MutableTemplateCents()->SetRu("template_cents");
        s.MutableTemplate()->SetTr("template_tr");
        s.MutableTemplateWhole()->SetTr("template_whole_tr");
        s.MutableTemplateCents()->SetTr("template_cents_tr");

        return s;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TCurrencyDumperTest);

void TCurrencyDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TCurrencyDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    auto codeToId = Dumper_->Dump();
    auto expected = TMap<TString, i32>{{RubCode, RubId}};
    UNIT_ASSERT_EQUAL(codeToId, expected);
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TCurrency>{CreateModel()}));
}
