#include "district_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TDistrictSelectQuery::TDistrictSelectQuery()
            : TSelectQuery("www_district")
            , IdField(AddField("id"))

            , TitleDefaultField(AddField("title"))

            , CapitalSettlementIdField(AddField("settlement_id"))
            , RegionIdField(AddField("region_id"))

            , IsDisputedTerritoryField(AddField("disputed_territory"))
        {
        }

        TDistrictDumper::TDistrictDumper(IFetcher& fetcher,
                                         IObjectWriter<TDistrict>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TSet<ui32> TDistrictDumper::Dump(const TSet<ui32>& regionIds) {
            INFO_LOG << "Run the district dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TSet<ui32> ids;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TDistrict record;

                const auto id = ParseId(row[Query.IdField]);
                record.SetId(id);

                record.SetTitleDefault(row[Query.TitleDefaultField]);

                record.SetCapitalSettlementId(ParseId(row[Query.CapitalSettlementIdField])); // TODO consistency check
                {
                    const auto regionId = ParseId(row[Query.RegionIdField]);
                    if (regionId != 0 && regionIds.count(regionId) == 0) {
                        WARNING_LOG << "SKIP TDistrict: Can not find a region by id: [" << regionId << "] for district with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetRegionId(regionId);
                }

                record.SetIsDisputedTerritory(ParseBool(row[Query.IsDisputedTerritoryField]));

                ids.insert(id);
                Writer_.Write(record);
            };

            if (ids.empty()) {
                ythrow yexception() << "District dumper has no records.";
            }
            INFO_LOG << "The district dumper has dumped. Total count of districts is " << ids.size() << Endl;

            return ids;
        }
    }
}
