#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/district.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TDistrictSelectQuery: public TSelectQuery {
        public:
            TDistrictSelectQuery();

        public:
            const ui32 IdField;

            const ui32 TitleDefaultField;

            const ui32 CapitalSettlementIdField;
            const ui32 RegionIdField;

            const ui32 IsDisputedTerritoryField;
        };

        class TDistrictDumper {
        public:
            TDistrictDumper(IFetcher& fetcher,
                            IObjectWriter<NData::TDistrict>& writer);
            TSet<ui32> Dump(const TSet<ui32>& regionIds);

        public:
            const TDistrictSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TDistrict>& Writer_;
        };
    }
}
