#include "named_train_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>

#include <library/cpp/logger/global/global.h>

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TNamedTrainSelectQuery::TNamedTrainSelectQuery()
            : TSelectQuery("www_deluxetrain", false)
            , IdField(AddField("id"))
            , NumbersField(AddField("numbers"))
            , IsDeluxeField(AddField("deluxe"))
            , IsHighSpeedField(AddField("high_speed"))
            , TitleDefaultField(AddField("title"))
            , TitleRuField(AddField("title_ru"))
            , TitleEnField(AddField("title_en"))
            , TitleUkField(AddField("title_uk"))
            , TitleTrField(AddField("title_tr"))
        {
        }

        TNamedTrainDumper::TNamedTrainDumper(IFetcher& fetcher, IObjectWriter<TNamedTrain>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        void TNamedTrainDumper::Dump() {
            INFO_LOG << "Run the named train dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            i32 count = 0;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TNamedTrain record;

                record.SetId(ParseId(row[Query.IdField]));
                record.SetNumbers(row[Query.NumbersField]);
                record.SetIsDeluxe(ParseBool(row[Query.IsDeluxeField]));
                record.SetIsHighSpeed(ParseBool(row[Query.IsHighSpeedField]));
                record.SetTitleDefault(row[Query.TitleDefaultField]);

                record.MutableTitle()->SetRu(row[Query.TitleRuField]);
                record.MutableTitle()->SetEn(row[Query.TitleEnField]);
                record.MutableTitle()->SetUk(row[Query.TitleUkField]);
                record.MutableTitle()->SetTr(row[Query.TitleTrField]);

                Writer_.Write(record);
                count++;
            };
            if (!count) {
                ythrow yexception() << "Named train dumper has no records.";
            }

            INFO_LOG << "The named train dumper has dumped: total count of records is " << count << Endl;
        }
    }
}
