#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/named_train.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/map.h>
#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TNamedTrainSelectQuery: public TSelectQuery {
        public:
            TNamedTrainSelectQuery();

        public:
            const i32 IdField;
            const i32 NumbersField;
            const i32 IsDeluxeField;
            const i32 IsHighSpeedField;
            const i32 TitleDefaultField;

            const i32 TitleRuField;
            const i32 TitleEnField;
            const i32 TitleUkField;
            const i32 TitleTrField;
        };

        class TNamedTrainDumper {
        public:
            TNamedTrainDumper(NRasp::NDumper::IFetcher& fetcher, IObjectWriter<NData::TNamedTrain>& writer);
            void Dump();

        public:
            const TNamedTrainSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TNamedTrain>& Writer_;
        };
    }
}
