#include "named_train_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/string/cast.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

Y_UNIT_TEST_SUITE(NamedTrainSelectQueryTest) {
    Y_UNIT_TEST(Test) {
        auto res = TNamedTrainSelectQuery();
        UNIT_ASSERT_STRINGS_EQUAL(
                res.Str(),
                "SELECT id, numbers, deluxe, high_speed, title, title_ru, title_en, title_uk, title_tr FROM www_deluxetrain;");
    }
}

class TNamedTrainDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TNamedTrainDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TNamedTrain> ObjectWriter_;
    THolder<TNamedTrainDumper> Dumper_;

    TString Numbers;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TNamedTrain>();

        Dumper_ = MakeHolder<TNamedTrainDumper>(Fetcher_, ObjectWriter_);
        Numbers = "code1/code2/code3";
    }

    TVector<TString> CreateRow() {
        return {
            ToString(1),      // id
            Numbers, // numbers
            "1",                 // deluxe
            "0",                 // high_speed
            "поезд",             // title
            "поезд ru",          // title_ru
            "train",             // title_en
            "",                  // title_uk
            "поезд",             // title_tr
        };
    }
    TNamedTrain CreateModel() {
        TNamedTrain record;

        record.SetId(1);
        record.SetNumbers(Numbers);
        record.SetIsDeluxe(true);
        record.SetIsHighSpeed(false);
        record.SetTitleDefault("поезд");

        record.MutableTitle()->SetRu("поезд ru");
        record.MutableTitle()->SetEn("train");
        record.MutableTitle()->SetUk("");
        record.MutableTitle()->SetTr("поезд");

        return record;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TNamedTrainDumperTest);

void TNamedTrainDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TNamedTrainDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});
    Dumper_->Dump();

    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TNamedTrain>{CreateModel()}));
}
