#include "pointsynonym_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TPointSynonymSelectQuery::TPointSynonymSelectQuery()
            : TSelectQuery("www_pointsynonym")
            , IdField(AddField("id"))

            , TitleField(AddField("title"))
            , ContentTypeIdField(AddField("content_type_id"))
            , ObjectIdField(AddField("object_id"))
            , AutoField(AddField("auto"))
            , SearchTypeField(AddField("search_type"))
            , LanguageField(AddField("language"))
        {
        }

        TPointSynonymDumper::TPointSynonymDumper(IFetcher& fetcher, IObjectWriter<TPointSynonym>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TSet<ui32> TPointSynonymDumper::Dump() {
            INFO_LOG << "Run the point synonym dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TSet<ui32> ids;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TPointSynonym record;

                const auto id = ParseId(row[Query.IdField]);

                record.SetId(id);
                record.SetTitle(row[Query.TitleField]);
                record.SetContentTypeId(ParseId(row[Query.ContentTypeIdField]));
                record.SetObjectId(ParseId(row[Query.ObjectIdField]));
                record.SetAuto(ParseBool(row[Query.AutoField]));
                record.SetSearchType(row[Query.SearchTypeField]);
                record.SetLanguage(row[Query.LanguageField]);

                ids.insert(id);
                Writer_.Write(record);
            };
            if (ids.empty()) {
                ythrow yexception() << "Point synonym dumper has no records.";
            }

            INFO_LOG << "The point synonym dumper has dumped. Total count of points synonyms is " << ids.size() << Endl;

            return ids;
        }
    }
}
