#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/linguistic_provider/linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/pointsynonym.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>
#include <util/string/join.h>

namespace NRasp {
    namespace NDumper {
        class TPointSynonymSelectQuery: public TSelectQuery {
        public:
            TPointSynonymSelectQuery();

        public:
            const ui32 IdField;

            const ui32 TitleField;
            const ui32 ContentTypeIdField;
            const ui32 ObjectIdField;
            const ui32 AutoField;
            const ui32 SearchTypeField;
            const ui32 LanguageField;
        };

        class TPointSynonymDumper {
        public:
            TPointSynonymDumper(IFetcher& fetcher, IObjectWriter<NData::TPointSynonym>& writer);
            TSet<ui32> Dump();

        public:
            const TPointSynonymSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TPointSynonym>& Writer_;
        };
    }
}
