#include "pointsynonym_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/fabrics.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/fake_linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TPointSynonymDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TPointSynonymDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TPointSynonym> ObjectWriter_;
    THolder<TPointSynonymDumper> Dumper_;

    const ui32 DefaultId_ = 999;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TPointSynonym>();
        Dumper_ = MakeHolder<TPointSynonymDumper>(Fetcher_, ObjectWriter_);
    }

    TVector<TString> CreateRow() {
        return {
            ToString(DefaultId_), // id
            "title_value",        // title
            ToString(1000),       // content_type_id
            ToString(2000),       // object_id
            ToString(0),          // auto
            "search_type_value",  // search_type
            "lang", // language
        };
    }

    TPointSynonym CreateModel() {
        TPointSynonym record;

        record.SetId(DefaultId_);
        record.SetTitle("title_value");
        record.SetContentTypeId(1000);
        record.SetObjectId(2000);
        record.SetAuto(false);
        record.SetSearchType("search_type_value");
        record.SetLanguage("lang");

        return record;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TPointSynonymDumperTest);

void TPointSynonymDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TPointSynonymDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    auto ids = Dumper_->Dump();
    UNIT_ASSERT_EQUAL(ids, TSet<ui32>{DefaultId_});
    UNIT_ASSERT_STRINGS_EQUAL(ToJson(ObjectWriter_.GetResult()), ToJson(TVector<TPointSynonym>{CreateModel()}));
}
