#pragma once

#include "aviaalliance_dumper.h"
#include "carrier_dumper.h"
#include "country_dumper.h"
#include "currency_dumper.h"
#include "district_dumper.h"
#include "named_train_dumper.h"
#include "pointsynonym_dumper.h"
#include "region_dumper.h"
#include "route_dumper.h"
#include "settlement_code_dumper.h"
#include "settlement_dumper.h"
#include "station_code_dumper.h"
#include "station_dumper.h"
#include "station_express_alias_dumper.h"
#include "station_to_settlement_dumper.h"
#include "supplier_dumper.h"
#include "thread_dumper.h"
#include "thread_station_dumper.h"
#include "thread_tariff_dumper.h"
#include "train_tariffinfo_dumper.h"
#include "transport_model_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/http_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_helpers.h>
#include <travel/rasp/rasp_data/dumper/lib/linguistic_provider/geobase_linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/protobuf_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/railway_provider/readable_timezone_dumper.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_loader.h>
#include <travel/rasp/rasp_data/dumper/lib/vehicle_producer_provider/vehicle_producer_provider.h>

#include <library/cpp/geobase/lookup.hpp>
#include <library/cpp/logger/global/global.h>

#include <util/generic/string.h>

namespace NRasp {
    namespace NDumper {
        class TRaspDataDumper {
        public:
            TRaspDataDumper(const TString& rootPath, const TString& geobasePath,
                const TString& tankerAuthToken, const TMySqlConfig& config);
            void Dump();

        private:
            TString MakeFilePath(const TString& name);

        private:
            TString RootPath_;
            TString GeobasePath_;
            TString TankerAuthToken_;
            TMySqlConfig MySqlConfig_;
        };
    }
}
