#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/linguistic_provider/linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/region.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>
#include <util/string/join.h>

namespace NRasp {
    namespace NDumper {
        class TRegionSelectQuery: public TSelectQuery {
        public:
            TRegionSelectQuery();

        public:
            const ui32 IdField;

            const ui32 TitleDefaultField;
            const ui32 TitleRuField;
            const ui32 TitleUkField;
            const ui32 TitleEnField;
            const ui32 TitleTrField;

            const ui32 CountryIdField;
            const ui32 TimeZoneField;
            const ui32 GeoIdField;

            const ui32 IsDisputedTerritoryField;
            const ui32 IsHiddenField;

            const ui32 AgentGeoIdField;
            const ui32 KladrIdField;
            const ui32 KoatuuField;
        };

        class TRegionDumper {
        public:
            TRegionDumper(IFetcher& fetcher, IObjectWriter<NData::TRegion>& writer,
                          const ILinguisticProvider& linguisticProvider,
                          const TTimeZoneProvider& timeZoneProvider);
            TSet<ui32> Dump(const TSet<ui32>& countryIds);

        public:
            const TRegionSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TRegion>& Writer_;
            const ILinguisticProvider& LinguisticProvider_;
            const TTimeZoneProvider& TimeZoneProvider_;

            TString GetNominativeCase(const TString& lang, const TString& title, i32 geoId);
        };
    }
}
