#include "route_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TRouteSelectQuery::TRouteSelectQuery()
            : TSelectQuery("www_route", false)
            , IdField(AddField("id"))
            , SupplierIdField(AddField("supplier_id"))
            , IsHiddenField(AddField("hidden"))
            , TransportTypeIdField(AddField("t_type_id"))
        {
        }

        TRouteDumper::TRouteDumper(IFetcher& fetcher,
                                   IObjectWriter<TRoute>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer){};

        TRouteLoadingInfo TRouteDumper::Dump(const TSet<i32>& supplierIds) {
            INFO_LOG << "The route dumper has ran" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TRouteLoadingInfo info;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TRoute record;

                i32 id = ParseId(row[Query.IdField]);
                record.SetId(id);
                {
                    const auto supplierId = ParseId(row[Query.SupplierIdField]);
                    if (supplierId != 0 && !supplierIds.contains(supplierId)) {
                        WARNING_LOG << "SKIP TRoute: Can not find a supplier by id: [" << supplierId << "] for route with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetSupplierId(supplierId);
                }
                record.SetIsHidden(ParseBool(row[Query.IsHiddenField]));

                {
                    auto transportTypeId = ParseId(row[Query.TransportTypeIdField]);
                    if (!TTransport_EType_IsValid(transportTypeId)) {
                        WARNING_LOG << "SKIP TRoute: Can not find transportTypeId with id [" << transportTypeId << "] for thread with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetTransportType(
                        static_cast<TTransport::EType>(transportTypeId));
                }

                info.Ids.insert(id);
                Writer_.Write(record);
            };

            if (info.Ids.empty()) {
                ythrow yexception() << "Route dumper has no records.";
            }
            INFO_LOG << "The route dumper has dumped. Total count of threads is " << info.Ids.size() << Endl;

            return info;
        }
    }
}
