#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/route.pb.h>
#include <travel/proto/dicts/rasp/transport.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TRouteSelectQuery: public TSelectQuery {
        public:
            TRouteSelectQuery();

        public:
            const i32 IdField;
            const i32 SupplierIdField;
            const i32 IsHiddenField;
            const i32 TransportTypeIdField;
        };

        struct TRouteLoadingInfo {
            TSet<i32> Ids;
        };

        class TRouteDumper {
        public:
            TRouteDumper(NRasp::NDumper::IFetcher& fetcher,
                          IObjectWriter<NData::TRoute>& writer);
            TRouteLoadingInfo Dump(const TSet<i32>& supplierId);

        public:
            const TRouteSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TRoute>& Writer_;
        };
    }
}
;
