#include "route_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

Y_UNIT_TEST_SUITE(RouteSelectQuery) {
    Y_UNIT_TEST(Test) {
        auto res = TRouteSelectQuery();
        UNIT_ASSERT_STRINGS_EQUAL(
            res.Str(),
            "SELECT id, supplier_id, hidden, t_type_id FROM www_route;");
    }
}

class TRouteDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TRouteDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST(TestUnknownTransportType);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TRoute> ObjectWriter_;
    THolder<TRouteDumper> Dumper_;
    TSet<i32> supplierIds_;
    TVector<TString> DefaultRow_;
    TRoute DefaultModel_;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TRoute>();
        Dumper_ = MakeHolder<TRouteDumper>(Fetcher_, ObjectWriter_);
        supplierIds_ = {2};
        DefaultRow_ = CreateRow();
        DefaultModel_ = CreateModel();
    }

    TVector<TString> CreateRow() {
        return {
            "100",   // id
            "2",     // supplier_id
            "0",     // hidden
            "3",     // t_type_id
        };
    }
    TRoute CreateModel() {
        TRoute s;
        s.SetId(100);
        s.SetSupplierId(2);
        s.SetTransportType(TTransport::TYPE_BUS);
        return s;
    }
    void TestEmpty();
    void TestOneRecord();
    void TestUnknownTransportType();
};

UNIT_TEST_SUITE_REGISTRATION(TRouteDumperTest);

void TRouteDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(supplierIds_), yexception);
}

void TRouteDumperTest::TestOneRecord() {
    Fetcher_.Add({DefaultRow_});

    auto info = Dumper_->Dump(supplierIds_);
    UNIT_ASSERT_EQUAL(info.Ids, TSet<i32>{100});
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TRoute>{DefaultModel_}));
}

void TRouteDumperTest::TestUnknownTransportType() {
    auto row = CreateRow();
    row[Dumper_->Query.TransportTypeIdField] = "666";
    Fetcher_.Add({row, DefaultRow_});

    auto info = Dumper_->Dump(supplierIds_);
    UNIT_ASSERT_EQUAL(info.Ids, TSet<i32>{100});
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TRoute>{DefaultModel_}));
}
