#include "settlement_code_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>

#include <library/cpp/logger/global/global.h>

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TSettlementCodeSelectQuery::TSettlementCodeSelectQuery()
            : TSelectQuery("www_settlementcode", false)
            , SettlementIdField(AddField("settlement_id"))
            , CodeField(AddField("code"))
            , SystemIdField(AddField("system_id"))
        {
        }

        TSettlementCodeDumper::TSettlementCodeDumper(IFetcher& fetcher,
                                                     IObjectWriter<TSettlementCode>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

         THashMap<i32, THashMap<i32, TString>> TSettlementCodeDumper::Dump() {
            INFO_LOG << "Run the SettlementCode dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TVector<TString> row(Query.Size());
            i32 count = 0;
            THashMap<i32, THashMap<i32, TString>> settlementIdToCodes;
            while (Fetcher_.GetNext(&row)) {
                TSettlementCode record;
                const auto settlementId = ParseId(row[Query.SettlementIdField]);
                const auto code = row[Query.CodeField];
                const auto systemId = ParseId(row[Query.SystemIdField]);

                if (!ECodeSystem_IsValid(systemId)) {
                    WARNING_LOG << "SKIP SETTLEMENT_CODE: Can not find a systemId: [" << systemId
                                << "] for settlementId: [" << settlementId << "]" << Endl;
                    continue;
                }

                record.SetSettlementId(settlementId);
                record.SetCode(code);
                record.SetSystemId(static_cast<ECodeSystem>(systemId));
                settlementIdToCodes[settlementId][systemId] = code;

                Writer_.Write(record);
                count++;
            };

            if (!count) {
                ythrow yexception() << "Settlement code dumper has no records.";
            }
            INFO_LOG << "The SettlementCode dumper has dumped: total count of entries is " << count << Endl;

            return settlementIdToCodes;
        }
    }
}
