#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/settlement_code.pb.h>

#include <util/generic/hash.h>

namespace NRasp {
    namespace NDumper {
        class TSettlementCodeSelectQuery: public TSelectQuery {
        public:
            TSettlementCodeSelectQuery();

        public:
            const i32 SettlementIdField;
            const i32 CodeField;
            const i32 SystemIdField;
        };

        class TSettlementCodeDumper {
        public:
            TSettlementCodeDumper(NRasp::NDumper::IFetcher& fetcher,
                                  IObjectWriter<NData::TSettlementCode>& writer);
            THashMap<i32, THashMap<i32, TString>> Dump();

        public:
            const TSettlementCodeSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TSettlementCode>& Writer_;
        };
    }
}
