#include "settlement_code_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TSettlementCodeDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TSettlementCodeDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TSettlementCode> ObjectWriter_;
    THolder<TSettlementCodeDumper> Dumper_;

    TString Code;
    i32 SettlementId;
    ECodeSystem SystemId;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TSettlementCode>();
        Dumper_ = MakeHolder<TSettlementCodeDumper>(Fetcher_, ObjectWriter_);

        Code = "ZZZ";
        SettlementId = 100500;
        SystemId = CODE_SYSTEM_CHARTEX;
    }

    TVector<TString> CreateRow() {
        return {
            ToString(SettlementId), // 0 settlement_id
            Code,                   // 1 code
            ToString((i32)SystemId) // 2 system_id
        };
    }

    TSettlementCode CreateModel() {
        TSettlementCode s;

        s.SetSettlementId(SettlementId);
        s.SetSystemId(SystemId);
        s.SetCode(Code);

        return s;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TSettlementCodeDumperTest);

void TSettlementCodeDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TSettlementCodeDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    Dumper_->Dump();

    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TSettlementCode>{CreateModel()}));
}
