#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/linguistic_provider/linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/settlement.pb.h>

#include <util/generic/set.h>
#include <util/generic/hash.h>

namespace NRasp {
    namespace NDumper {
        class TSettlementSelectQuery: public TSelectQuery {
        public:
            TSettlementSelectQuery();

        public:
            const i32 IdField;
            const i32 GeoIdField;
            const i32 CountryIdField;
            const i32 MajorityIdField;
            const i32 RegionIdField;
            const i32 DistrictIdField;
            const i32 DisputedTerritoryIdField;
            const i32 TimeZoneField;

            const i32 IsHiddenField;

            const i32 SlugField;

            const i32 LongitudeField;
            const i32 LatitudeField;

            const i32 TitleDefaultField;

            const i32 TitleRuNominativeField;
            const i32 TitleRuLocativePrepositionField;
            const i32 TitleRuGenitiveField;
            const i32 TitleRuAccusativeField;
            const i32 TitleRuPrepositionalField;

            const i32 TitleUkNominativeField;
            const i32 TitleEnNominativeField;
            const i32 TitleTrNominativeField;

            const i32 AbbrTitleDefaultField;
            const i32 AbbrTitleRuField;
            const i32 AbbrTitleUkField;
            const i32 AbbrTitleEnField;
            const i32 AbbrTitleTrField;

            const i32 PhoneInfoField;
            const i32 PhoneInfoShortField;

            const i32 AgentGeoIdField;
            const i32 KladrIdField;
            const i32 KoatuuField;

            const i32 BigCityField;
            const i32 HasTabloField;
            const i32 HasManyAirportsField;
            const i32 SuggestOrderField;

            const i32 IataField;
            const i32 SirenaIdField;
        };

        struct SettlementDumperResult {
            SettlementDumperResult(TSet<i32> settlementIds, THashMap<i32, i32> countryIdToCapitalTimeZoneId);

            TSet<i32> SettlementIds;
            THashMap<i32, i32> CountryIdToCapitalTimeZoneId;
        };

        class TSettlementDumper {
        public:
            TSettlementDumper(IFetcher& fetcher,
                              IObjectWriter<NData::TSettlement>& writer,
                              const ILinguisticProvider& linguisticProvider,
                              const TTimeZoneProvider& timezones);
            SettlementDumperResult
            Dump(const TSet<ui32>& districtIds, const TSet<ui32>& regionIds, const TSet<ui32>& countryIds);

        public:
            const TSettlementSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TSettlement>& Writer_;
            const ILinguisticProvider& LinguisticProvider_;
            const TTimeZoneProvider& TimeZoneProvider_;
        };
    }
}
