#include "station_code_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>

#include <library/cpp/logger/global/global.h>

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TStationCodeSelectQuery::TStationCodeSelectQuery()
            : TSelectQuery("www_stationcode", false)
            , StationIdField(AddField("station_id"))
            , CodeField(AddField("code"))
            , SystemIdField(AddField("system_id"))
        {
        }

        TStationCodeDumper::TStationCodeDumper(IFetcher& fetcher,
                                               IObjectWriter<TStationCode>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

         THashMap<i32, THashMap<i32, TString>> TStationCodeDumper::Dump() {
            INFO_LOG << "Run the StationCode dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TVector<TString> row(Query.Size());
            i32 count = 0;
            THashMap<i32, TString> stationIdToExpressCode;
            THashMap<i32, THashMap<i32, TString>> stationIdToCodes;
            while (Fetcher_.GetNext(&row)) {
                TStationCode record;
                const auto stationId = ParseId(row[Query.StationIdField]);
                const auto code = row[Query.CodeField];
                const auto systemId = ParseId(row[Query.SystemIdField]);

                if (!ECodeSystem_IsValid(systemId)) {
                    WARNING_LOG << "SKIP STATION_CODE: Can not find a systemId: [" << systemId << "] for stationId: [" << stationId << "]" << Endl;
                    continue;
                }

                record.SetStationId(stationId);
                record.SetCode(code);
                record.SetSystemId(static_cast<ECodeSystem>(systemId));
                stationIdToCodes[stationId][systemId] = code;
                if (record.GetSystemId() == CODE_SYSTEM_EXPRESS) {
                    stationIdToExpressCode[stationId] = code;
                }

                Writer_.Write(record);
                count++;
            };

            if (stationIdToExpressCode.empty()) {
                ythrow yexception() << "stationIdToExpressCode is empty.";
            }
            if (!count) {
                ythrow yexception() << "Station code dumper has no records.";
            }
            INFO_LOG << "stationExpressCodes map has entries: " << stationIdToExpressCode.size() << Endl;
            INFO_LOG << "The StationCode dumper has dumped: total count of entries is " << count << Endl;

            return stationIdToCodes;
        }
    }
}
