#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/station_code.pb.h>

#include <util/generic/hash.h>

namespace NRasp {
    namespace NDumper {
        class TStationCodeSelectQuery: public TSelectQuery {
        public:
            TStationCodeSelectQuery();

        public:
            const i32 StationIdField;
            const i32 CodeField;
            const i32 SystemIdField;
        };

        class TStationCodeDumper {
        public:
            TStationCodeDumper(NRasp::NDumper::IFetcher& fetcher,
                               IObjectWriter<NData::TStationCode>& writer);
            THashMap<i32, THashMap<i32, TString>> Dump();

        public:
            const TStationCodeSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TStationCode>& Writer_;
        };
    }
}
