#include "station_code_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TStationCodeDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TStationCodeDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TStationCode> ObjectWriter_;
    THolder<TStationCodeDumper> Dumper_;

    TString Code;
    i32 StationId;
    ECodeSystem SystemId;
    THashMap<i32, THashMap<i32, TString>> StationIdToExpressCode;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TStationCode>();
        Dumper_ = MakeHolder<TStationCodeDumper>(Fetcher_, ObjectWriter_);

        Code = "АХГ";
        StationId = 9600185;
        SystemId = CODE_SYSTEM_EXPRESS;
        StationIdToExpressCode = {{StationId, {{SystemId, Code}}}};
    }

    TVector<TString> CreateRow() {
        return {
            ToString(StationId),    // 0 station_id
            Code,                   // 1 code
            ToString((i32)SystemId) // 2 system_id
        };
    }

    TStationCode CreateModel() {
        TStationCode s;

        s.SetStationId(StationId);
        s.SetSystemId(SystemId);
        s.SetCode(Code);

        return s;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TStationCodeDumperTest);

void TStationCodeDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TStationCodeDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    auto stationIdToExpressCode = Dumper_->Dump();

    UNIT_ASSERT_EQUAL(stationIdToExpressCode, StationIdToExpressCode);
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TStationCode>{CreateModel()}));
}
