#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/railway_provider/railway_timezone_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/station.pb.h>
#include <travel/proto/dicts/rasp/transport.pb.h>

#include <util/generic/set.h>
#include <util/generic/hash.h>

#include <regex>

namespace NRasp {
    namespace NDumper {
        class TStationSelectQuery: public TSelectQuery {
        public:
            TStationSelectQuery();

        public:
            const i32 IdField;
            const i32 SettlementIdField;
            const i32 MajorityIdField;
            const i32 TimeZoneField;

            const i32 IsHiddenField;

            const i32 LongitudeField;
            const i32 LatitudeField;

            const i32 NotGeneralizeField;

            const i32 TitleDefaultField;

            const i32 RuNominativeTitleField;
            const i32 RuPrepositionField;
            const i32 RuGenitiveTitleField;
            const i32 RuAccusativeTitleField;
            const i32 RuPrepositionalTitleField;
            const i32 UkNominativeTitleField;

            const i32 PopularTitleDefaultField;

            const i32 PopularRuNominativeTitleField;
            const i32 PopularRuGenitiveTitleField;

            const i32 PopularUkNominativeTitleField;

            const i32 TypeIdField;
            const i32 TransportTypeIdField;

            const i32 RegionIdField;
            const i32 DistrictIdField;
            const i32 CountryIdField;
            const i32 AddressField;
            const i32 TitleEnField;
            const i32 TitleUkField;
            const i32 SiteUrlField;
            const i32 HowToGetToCityField;
            const i32 UseDirectionField;
            const i32 SuburbanZoneIdField;
            const i32 HasAeroexpressField;
            const i32 NearMetroField;
            const i32 MapZoomField;
            const i32 TypeChoicesField;
            const i32 LastChangeField;
            const i32 PhotoField;
            const i32 PanoramaUrlField;
            const i32 ShowSettlementField;
            const i32 TabloStateField;
            const i32 SupplierIdField;
            // preposition_dep probably is not used anymore, but I have not found the replacement. It's one of the old
            // fields mentioned here https://st.yandex-team.ru/RASPTICKETS-18316#5efdc0fae9ca8e60925ab434
            const i32 PrepositionDepField;
            const i32 FuzzyOnlyField;
            const i32 VirtualEndField;
            const i32 IncompleteBusScheduleField;
            const i32 ShowModeField;
            const i32 IsFuzzyField;
            const i32 IsSearchableToField;
            const i32 IsSearchableFromField;
            const i32 InStationScheduleField;
            const i32 TitleTrField;
            const i32 TitleRuOverrideField;
            const i32 TitleEnOverrideField;
            const i32 TitleUkOverrideField;
            const i32 TitleTrOverrideField;
            const i32 PopularTitleEnField;
            const i32 PopularTitleTrField;
            const i32 HowToGetToCityRuField;
            const i32 HowToGetToCityEnField;
            const i32 HowToGetToCityUkField;
            const i32 HowToGetToCityTrField;
            const i32 SchemaImageField;
            const i32 TimeZoneNotCheckField;
            const i32 AddressRuField;
            const i32 AddressEnField;
            const i32 AddressUkField;
            const i32 AddressTrField;
            const i32 TabloStatePrevField;
            const i32 InThreadField;
            const i32 ShowTabloStatField;
            const i32 IsBaseField;
            const i32 ModifiedAtField;
            const i32 UseInDepartureForecastField;
            const i32 UseInForecastField;
            const i32 IsBaseModifiedAtField;
            const i32 SlugField;
            const i32 AgreedStopTypeField;

        };

        class TStationDumper {
        public:
            TStationDumper(
                NRasp::NDumper::IFetcher& fetcher,
                IObjectWriter<NData::TStation>& writer,
                const TTimeZoneProvider& tzProvider,
                const TRailwayTimezoneProvider& railwayTimezoneProvider);
            TSet<i32> Dump(const TSet<i32>& settlementIds, const TSet<ui32>& districtIds, const TSet<ui32>& regionIds,
                           const TSet<ui32>& countryIds, const TSet<i32>& supplierIds, const THashMap<i32, THashMap<i32, TString>>& stationIdToCodes);

        public:
            const TStationSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TStation>& Writer_;
            const TTimeZoneProvider& TimeZoneProvider_;
            const TRailwayTimezoneProvider& RailwayTimezoneProvider_;
        };
    }
}
