#include "station_express_alias_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TStationExpressAliasSelectQuery::TStationExpressAliasSelectQuery()
            : TSelectQuery("www_stationexpressalias", false)
            , IdField(AddField("id"))
            , StationIdField(AddField("station_id"))
            , AliasField(AddField("alias"))
        {
        }

        TStationExpressAliasDumper::TStationExpressAliasDumper(IFetcher& fetcher,
                                                               IObjectWriter<TStationExpressAlias>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        void TStationExpressAliasDumper::Dump(const TSet<i32>& stationIds) {
            INFO_LOG << "Run the station alias dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            i32 count = 0;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                const auto id = ParseId(row[Query.IdField]);
                const auto stationId = ParseId(row[Query.StationIdField]);
                if (stationIds.count(stationId) == 0) {
                    WARNING_LOG << "SKIP Alias: Can not find station with id [" << stationId << "] for alias with id: [" << id << "]" << Endl;
                    continue;
                }

                TStationExpressAlias record;
                record.SetStationId(stationId);
                record.SetAlias(row[Query.AliasField]);

                Writer_.Write(record);
                ++count;
            };

            if (!count) {
                ythrow yexception() << "Station alias dumper has no records.";
            }
            INFO_LOG << "The Station alias dumper has dumped: total count of entries is " << count << Endl;
        }
    }
}