#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/station_express_alias.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TStationExpressAliasSelectQuery: public TSelectQuery {
        public:
            TStationExpressAliasSelectQuery();

        public:
            const i32 IdField;
            const i32 StationIdField;
            const i32 AliasField;
        };
        class TStationExpressAliasDumper {
        public:
            TStationExpressAliasDumper(NRasp::NDumper::IFetcher& fetcher,
                                       IObjectWriter<NData::TStationExpressAlias>& writer);
            void Dump(const TSet<i32>& stationIds);

        public:
            const TStationExpressAliasSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TStationExpressAlias>& Writer_;
        };
    }
}
