#include "station_express_alias_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TStationExpressAliasDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TStationExpressAliasDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST(TestUnknownStation);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TStationExpressAlias> ObjectWriter_;
    THolder<TStationExpressAliasDumper> Dumper_;

    TSet<i32> StationIds_;
    ui32 Id;
    i32 StationId;
    TString Alias;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TStationExpressAlias>();
        Dumper_ = MakeHolder<TStationExpressAliasDumper>(Fetcher_, ObjectWriter_);

        Id = 1;
        StationId = 9621381;
        Alias = "АКС";
        StationIds_ = {StationId};
    }

    TVector<TString> CreateRow() {
        return {
            ToString(Id),
            ToString(StationId),
            Alias
        };
    }
    TStationExpressAlias CreateModel() {
        TStationExpressAlias model;
        model.SetStationId(StationId);
        model.SetAlias(Alias);

        return model;
    }
    void TestEmpty();
    void TestOneRecord();
    void TestUnknownStation();
};

UNIT_TEST_SUITE_REGISTRATION(TStationExpressAliasDumperTest);

void TStationExpressAliasDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(StationIds_), yexception);
}

void TStationExpressAliasDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});
    Dumper_->Dump(StationIds_);

    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TStationExpressAlias>{CreateModel()}));
}

void TStationExpressAliasDumperTest::TestUnknownStation() {
    auto row = CreateRow();
    row[Dumper_->Query.StationIdField] = "666";
    Fetcher_.Add({row, CreateRow()});
    Dumper_->Dump(StationIds_);

    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TStationExpressAlias>{CreateModel()}));
}
