#include "station_to_settlement_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>

#include <library/cpp/logger/global/global.h>
#include <util/generic/hash_set.h>

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TStation2SettlementSelectQuery::TStation2SettlementSelectQuery()
            : TSelectQuery("www_station2settlement", false)
            , IdField(AddField("id"))
            , StationIdField(AddField("station_id"))
            , SettlementIdField(AddField("settlement_id"))
        {
        }

        TStation2SettlementDumper::TStation2SettlementDumper(IFetcher& fetcher,
                                                             IObjectWriter<TStation2Settlement>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        void TStation2SettlementDumper::Dump(const TSet<i32>& stationIds, const TSet<i32>& settlementIds) {
            INFO_LOG << "Run the s2s dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            i32 relationsCount = 0;
            TVector<TString> row(Query.Size());
            auto seenIds = THashSet<std::pair<i32, i32>>();
            while (Fetcher_.GetNext(&row)) {
                const auto id = ParseId(row[Query.IdField]);
                const auto stationId = ParseId(row[Query.StationIdField]);
                if (stationIds.count(stationId) == 0) {
                    WARNING_LOG << "SKIP S2S: Can not find station with id [" << id << "] for s2s with id: [" << stationId << "]" << Endl;
                    continue;
                }

                const auto settlementId = ParseId(row[Query.SettlementIdField]);
                if (settlementIds.count(settlementId) == 0) {
                    WARNING_LOG << "SKIP S2S: Can not find station with id [" << id << "] for s2s with id: [" << stationId << "]" << Endl;
                    continue;
                }
                TStation2Settlement record;
                ++relationsCount;

                auto rowId = std::make_pair(stationId, settlementId);
                if (seenIds.contains(rowId)) {
                    continue;
                }
                seenIds.insert(rowId);
                
                record.SetStationId(stationId);
                record.SetSettlementId(settlementId);

                Writer_.Write(record);
            };

            if (!relationsCount) {
                ythrow yexception() << "s2s dumper has no records.";
            }
            INFO_LOG << "The s2s dumper has dumped. Total count of s2s is " << relationsCount << Endl;
        }
    }
}
