#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/station_to_settlement.pb.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TStation2SettlementSelectQuery: public TSelectQuery {
        public:
            TStation2SettlementSelectQuery();

        public:
            const i32 IdField;
            const i32 StationIdField;
            const i32 SettlementIdField;
        };
        class TStation2SettlementDumper {
        public:
            TStation2SettlementDumper(NRasp::NDumper::IFetcher& fetcher,
                                      IObjectWriter<NData::TStation2Settlement>& writer);
            void Dump(const TSet<i32>& stationIds, const TSet<i32>& settlementsIds);

        public:
            const TStation2SettlementSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TStation2Settlement>& Writer_;
        };
    }
}
