#include "supplier_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TSupplierSelectQuery::TSupplierSelectQuery()
            : TSelectQuery("www_supplier", false)
            , IdField(AddField("id"))
            , TitleField(AddField("title"))
            , CodeField(AddField("code"))
            , CanBuyRuField(AddField("can_buy_ru"))
            , CanBuyUaField(AddField("can_buy_ua"))
            , SaleUrlTemplateField(AddField("sale_url_template"))
            , SaleStartDaysField(AddField("sale_start_days"))
            , SaleStopHoursField(AddField("sale_stop_hours"))
        {
        }

        TSupplierDumper::TSupplierDumper(IFetcher& fetcher,
                                         IObjectWriter<TSupplier>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TSet<i32> TSupplierDumper::Dump() {
            INFO_LOG << "Run the supplier dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TSet<i32> ids;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TSupplier record;

                record.SetId(ParseId(row[Query.IdField]));
                record.SetTitle(row[Query.TitleField]);
                record.SetCode(row[Query.CodeField]);
                record.SetCanBuyRu(ParseBool(row[Query.CanBuyRuField]));
                record.SetCanBuyUa(ParseBool(row[Query.CanBuyUaField]));
                record.SetSaleUrlTemplate(row[Query.SaleUrlTemplateField]);
                record.SetSaleStartDays(ParseI32(row[Query.SaleStartDaysField]));
                record.SetSaleStopHours(ParseI32(row[Query.SaleStopHoursField]));

                ids.insert(record.GetId());
                Writer_.Write(record);
            };
            if (ids.empty()) {
                ythrow yexception() << "Supplier dumper has no records.";
            }
            INFO_LOG << "The supplier dumper has dumped: Total count of suppliers is " << ids.size() << Endl;

            return ids;
        }
    }
}
