#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/supplier.pb.h>

#include <library/cpp/protobuf/protofile/protofile.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TSupplierSelectQuery: public TSelectQuery {
        public:
            TSupplierSelectQuery();

        public:
            const i32 IdField;
            const i32 TitleField;
            const i32 CodeField;
            const i32 CanBuyRuField;
            const i32 CanBuyUaField;
            const i32 SaleUrlTemplateField;
            const i32 SaleStartDaysField;
            const i32 SaleStopHoursField;
        };

        class TSupplierDumper {
        public:
            TSupplierDumper(NRasp::NDumper::IFetcher& fetcher,
                            IObjectWriter<NData::TSupplier>& writer);
            TSet<i32> Dump();

        public:
            const TSupplierSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TSupplier>& Writer_;
        };
    }
}
