#include "supplier_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TSupplierDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TSupplierDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST(TestCanBuyRu);
    UNIT_TEST(TestCanBuyUa);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TSupplier> ObjectWriter_;
    THolder<TSupplierDumper> Dumper_;
    i32 DefaultId_;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TSupplier>();

        Dumper_ = MakeHolder<TSupplierDumper>(Fetcher_, ObjectWriter_);
        DefaultId_ = 10;
    }

    TVector<TString> CreateRow() {
        return {
            ToString(DefaultId_),      // 0 id
            "title_value",             // 1 title
            "code_value",              // 2 code
            "1",                       // 3 can_buy_ru
            "1",                       // 4 can_buy_ua
            "sale_url_template_value", // 5 sale_url_template
            "100",                     // 6 sale_start_days
            "1000",                    // 7 sale_stop_hours
        };
    }
    TSupplier CreateModel() {
        TSupplier s;

        s.SetId(DefaultId_);
        s.SetTitle("title_value");
        s.SetCode("code_value");
        s.SetCanBuyRu(true);
        s.SetCanBuyUa(true);
        s.SetSaleUrlTemplate("sale_url_template_value");
        s.SetSaleStartDays(100);
        s.SetSaleStopHours(1000);

        return s;
    }
    void TestEmpty();
    void TestOneRecord();
    void TestCanBuyRu();
    void TestCanBuyUa();
};

UNIT_TEST_SUITE_REGISTRATION(TSupplierDumperTest);

void TSupplierDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TSupplierDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    auto ids = Dumper_->Dump();
    UNIT_ASSERT_EQUAL(ids, TSet<i32>{DefaultId_});
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TSupplier>{CreateModel()}));
}

void TSupplierDumperTest::TestCanBuyRu() {
    auto row = CreateRow();
    row[Dumper_->Query.CanBuyRuField] = "0";
    Fetcher_.Add({row});

    auto ids = Dumper_->Dump();
    UNIT_ASSERT_EQUAL(ids, TSet<i32>{DefaultId_});
    auto model = CreateModel();
    model.SetCanBuyRu(false);
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TSupplier>{model}));
}

void TSupplierDumperTest::TestCanBuyUa() {
    auto row = CreateRow();
    row[Dumper_->Query.CanBuyUaField] = "0";
    Fetcher_.Add({row});

    auto ids = Dumper_->Dump();
    UNIT_ASSERT_EQUAL(ids, TSet<i32>{DefaultId_});
    auto model = CreateModel();
    model.SetCanBuyUa(false);
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TSupplier>{model}));
}
