#include "thread_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TThreadSelectQuery::TThreadSelectQuery()
            : TSelectQuery("www_rthread", false)
            , IdField(AddField("id"))
            , IsHiddenField(AddField("hidden"))
            , TzYearDaysField(AddField("tz_year_days"))
            , TzStartTimeField(AddField("tz_start_time"))
            , TypeIdField(AddField("type_id"))
            , TitleCommonField(AddField("title_common"))
            , RouteNumberField(AddField("route_number"))
            , TransportTypeIdField(AddField("t_type_id"))
            , UidField(AddField("uid"))
            , RouteIdField(AddField("route_id"))
            , CompanyIdField(AddField("company_id"))
        {
        }

        TThreadDumper::TThreadDumper(IFetcher& fetcher,
                                     IObjectWriter<TThread>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer){};

        TThreadLoadingInfo TThreadDumper::Dump(const TSet<i32>& stationIds, const TSet<i32>& settlementIds) {
            INFO_LOG << "The thread dumper has ran" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TThreadLoadingInfo info;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                TThread record;

                i32 id = ParseId(row[Query.IdField]);
                record.SetId(id);
                record.SetIsHidden(ParseBool(row[Query.IsHiddenField]));

                {
                    auto mask = ParseYearMask(row[Query.TzYearDaysField]);
                    (*record.MutableYearDays()) = ::google::protobuf::RepeatedField<i32>(
                        mask.begin(), mask.end());
                }
                record.SetTzStartTime(ParseTime(row[Query.TzStartTimeField]));

                {
                    auto typeId = ParseId(row[Query.TypeIdField]);
                    if (!TThread_EType_IsValid(typeId)) {
                        WARNING_LOG << "SKIP TThread: Can not find typeId with id [" << typeId << "] for thread with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetType(static_cast<TThread::EType>(typeId));
                }
                if (!ParseTitleCommon(id, row[Query.TitleCommonField], stationIds, settlementIds, record.MutableCommonTitle())) {
                    WARNING_LOG << "SKIP TThread: Can not parse title common with for thread with id: [" << id << "]" << Endl;
                    continue;
                }
                record.SetNumber(row[Query.RouteNumberField]);
                {
                    auto transportTypeId = ParseId(row[Query.TransportTypeIdField]);
                    if (!TTransport_EType_IsValid(transportTypeId)) {
                        WARNING_LOG << "SKIP TThread: Can not find transportTypeId with id [" << transportTypeId << "] for thread with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetTransportType(
                        static_cast<TTransport::EType>(transportTypeId));
                }
                TString uid(row[Query.UidField]);
                record.SetUid(uid);
                record.SetRouteId(ParseId(row[Query.RouteIdField]));
                record.SetCompanyId(ParseId(row[Query.CompanyIdField]));

                info.UidToId[uid] = id;
                info.Ids.insert(id);
                Writer_.Write(record);
            };

            if (info.Ids.empty()) {
                ythrow yexception() << "Thread dumper has no records.";
            }
            INFO_LOG << "The thread dumper has dumped. Total count of threads is " << info.Ids.size() << Endl;

            return info;
        }
    }
}
