#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/title_common/title_common.h>
#include <travel/rasp/rasp_data/dumper/lib/year_mask/year_mask.h>
#include <travel/proto/dicts/rasp/thread.pb.h>
#include <travel/proto/dicts/rasp/transport.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>
#include <util/generic/map.h>

namespace NRasp {
    namespace NDumper {
        class TThreadSelectQuery: public TSelectQuery {
        public:
            TThreadSelectQuery();

        public:
            const i32 IdField;
            const i32 IsHiddenField;
            const i32 TzYearDaysField;
            const i32 TzStartTimeField;
            const i32 TypeIdField;
            const i32 TitleCommonField;
            const i32 RouteNumberField;
            const i32 TransportTypeIdField;
            const i32 UidField;
            const i32 RouteIdField;
            const i32 CompanyIdField;
        };

        struct TThreadLoadingInfo {
            TSet<i32> Ids;
            TMap<TString, i32> UidToId;
        };

        class TThreadDumper {
        public:
            TThreadDumper(NRasp::NDumper::IFetcher& fetcher,
                          IObjectWriter<NData::TThread>& writer);
            TThreadLoadingInfo Dump(const TSet<i32>& stationIds, const TSet<i32>& settlementIds);

        public:
            const TThreadSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TThread>& Writer_;
        };
    }
}
