#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/thread_station.pb.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TThreadStationSelectQuery: public TSelectQuery {
        public:
            TThreadStationSelectQuery();

        public:
            const i32 IdField;
            const i32 StationIdField;
            const i32 TzDepartureField;
            const i32 TzArrivalField;
            const i32 TimeZoneField;
            const i32 IsSearchableFromField;
            const i32 IsSearchableToField;
            const i32 DepartureCodeSharingField;
            const i32 ArrivalCodeSharingField;
            const i32 ThreadIdField;
            const i32 IsTechnicalStopField;
        };

        class TThreadStationDumper {
        public:
            TThreadStationDumper(NRasp::NDumper::IFetcher& fetcher,
                                 IObjectWriter<NData::TThreadStation>& writer,
                                 const TTimeZoneProvider& timeZoneProvider);
            void Dump(const TSet<i32>& stationIds, const TSet<i32>& threadIds);

        public:
            TThreadStationSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TThreadStation>& Writer_;
            const TTimeZoneProvider& TimeZoneProvider_;
        };
    }
}
