#pragma once

#include <travel/proto/dicts/rasp/thread_tariff.pb.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>

#include <util/generic/set.h>
#include <util/generic/map.h>

namespace NRasp {
    namespace NDumper {
        class TThreadTariffSelectQuery: public TSelectQuery {
        public:
            TThreadTariffSelectQuery();

        public:
            const i32 IdField;
            const i32 ThreadlUidField;
            const i32 StationFromIdField;
            const i32 StationToIdField;
            const i32 TariffField;
            const i32 YearsDaysFromField;
            const i32 SettlmenentFromIdField;
            const i32 SettlmenentToIdField;
            const i32 CurrencyField;
            const i32 TimeZoneFromField;
            const i32 TTypeIdField;
            const i32 SupplierIdField;
            const i32 TimeFromField;
        };
        class TThreadTariffDumper {
        public:
            TThreadTariffDumper(NRasp::NDumper::IFetcher& fetcher,
                                IObjectWriter<NData::TThreadTariff>& writer,
                                TTimeZoneProvider& TimeZoneProvider_);
            void Dump(const TMap<TString, i32>& threadUidToId, const TSet<i32>& stationIds, const TSet<i32>& settlementIds, const TSet<i32>& supplierIds, const TMap<TString, i32>& currencyCodeToId);

        public:
            const TThreadTariffSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TThreadTariff>& Writer_;
            TTimeZoneProvider& TimeZoneProvider_;
        };
    }
}
