#include "train_tariffinfo_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TTrainTariffInfoSelectQuery::TTrainTariffInfoSelectQuery()
            : TSelectQuery("train_tariffinfo", false)
            , IdField(AddField("id"))
            , CodeField(AddField("code"))
            , TitleRuField(AddField("title_ru"))
            , WithoutPlaceField(AddField("without_place"))
            , ImRequestCodeField(AddField("im_request_code"))
            , ImResponseCodesField(AddField("im_response_codes"))
            , NeedDocumentField(AddField("need_document"))
            , MinAgeField(AddField("min_age"))
            , MinAgeIncludesBirthdayField(AddField("min_age_includes_birthday"))
            , MaxAgeField(AddField("max_age"))
            , MaxAgeIncludesBirthdayField(AddField("max_age_includes_birthday"))
        {
        }

        TTrainTariffInfoDumper::TTrainTariffInfoDumper(NRasp::NDumper::IFetcher& fetcher,
                                                       IObjectWriter<TTrainTariffInfo>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        void TTrainTariffInfoDumper::Dump() {
            INFO_LOG << "Run the TrainTariffInfo dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TVector<TString> row(Query.Size());
            i32 count = 0;
            while (Fetcher_.GetNext(&row)) {
                TTrainTariffInfo record;

                record.SetId(ParseId(row[Query.IdField]));
                record.SetCode(row[Query.CodeField]);
                record.SetTitleRu(row[Query.TitleRuField]);
                record.SetWithoutPlace(ParseBool(row[Query.WithoutPlaceField]));
                record.SetImRequestCode(row[Query.ImRequestCodeField]);
                record.SetImResponseCodes(row[Query.ImResponseCodesField]);
                record.SetNeedDocument(ParseBool(row[Query.NeedDocumentField]));
                record.SetMinAge(ParseId(row[Query.MinAgeField]));
                record.SetMinAgeIncludesBirthday(ParseBool(row[Query.MinAgeIncludesBirthdayField]));
                record.SetMaxAge(ParseId(row[Query.MaxAgeField]));
                record.SetMaxAgeIncludesBirthday(ParseBool(row[Query.MaxAgeIncludesBirthdayField]));

                Writer_.Write(record);
                count++;
            };

            if (!count) {
                ythrow yexception() << "Train tariff info dumper has no records.";
            }
            INFO_LOG << "The TrainTariffInfo dumper has dumped: total count of entries is " << count << Endl;
        }
    }
}
