#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/train_tariffinfo.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/map.h>

namespace NRasp {
    namespace NDumper {
        class TTrainTariffInfoSelectQuery: public TSelectQuery {
        public:
            TTrainTariffInfoSelectQuery();

        public:
            const i32 IdField;
            const i32 CodeField;
            const i32 TitleRuField;
            const i32 WithoutPlaceField;
            const i32 ImRequestCodeField;
            const i32 ImResponseCodesField;
            const i32 NeedDocumentField;
            const i32 MinAgeField;
            const i32 MinAgeIncludesBirthdayField;
            const i32 MaxAgeField;
            const i32 MaxAgeIncludesBirthdayField;
        };

        class TTrainTariffInfoDumper {
        public:
            TTrainTariffInfoDumper(NRasp::NDumper::IFetcher& fetcher,
                                   IObjectWriter<NData::TTrainTariffInfo>& writer);
            void Dump();

        public:
            TTrainTariffInfoSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TTrainTariffInfo>& Writer_;
        };
    }
}
