#include "train_tariffinfo_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/string/cast.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TTrainTariffInfoDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TTrainTariffInfoDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TTrainTariffInfo> ObjectWriter_;
    THolder<TTrainTariffInfoDumper> Dumper_;

    i32 Id_;
    TString Code_;
    TString TitleRu_;
    bool WithoutPlace_;
    TString ImRequestCode_;
    TString ImResponseCodes_;
    bool NeedDocument_;
    i32 MinAge_;
    bool MinAgeIncludesBirthday_;
    i32 MaxAge_;
    bool MaxAgeIncludesBirthday_;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TTrainTariffInfo>();

        Dumper_ = MakeHolder<TTrainTariffInfoDumper>(Fetcher_, ObjectWriter_);
        Id_ = 84;
        Code_ = "code";
        TitleRu_ = "titleRu";
        WithoutPlace_ = true;
        ImRequestCode_ = "imRequestCode";
        ImResponseCodes_ = "imResponseCodes";
        NeedDocument_ = true;
        MinAge_ = 0;
        MinAgeIncludesBirthday_ = false;
        MaxAge_ = 2;
        MaxAgeIncludesBirthday_ = true;
    }

    TVector<TString> CreateRow() {
        return {
            ToString(Id_),                      // 0 id
            Code_,                              // 1 code
            TitleRu_,                           // 2 titleRu
            ToString(WithoutPlace_),            // 3 without_place
            ImRequestCode_,                     // 4 im_request_code
            ImResponseCodes_,                   // 5 im_response_codes
            ToString(NeedDocument_),            // 6 need_document
            ToString(MinAge_),                  // 7 min_age
            ToString(MinAgeIncludesBirthday_),  // 8 min_age_includes_birthday
            ToString(MaxAge_),                  // 9 max_age
            ToString(MaxAgeIncludesBirthday_),  // 10 max_age_includes_birthday
        };
    }
    TTrainTariffInfo CreateModel() {
        TTrainTariffInfo model;

        model.SetId(Id_);
        model.SetCode(Code_);
        model.SetTitleRu(TitleRu_);
        model.SetWithoutPlace(WithoutPlace_);
        model.SetImRequestCode(ImRequestCode_);
        model.SetImResponseCodes(ImResponseCodes_);
        model.SetNeedDocument(NeedDocument_);
        model.SetMinAge(MinAge_);
        model.SetMinAgeIncludesBirthday(MinAgeIncludesBirthday_);
        model.SetMaxAge(MaxAge_);
        model.SetMaxAgeIncludesBirthday(MaxAgeIncludesBirthday_);

        return model;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TTrainTariffInfoDumperTest);

void TTrainTariffInfoDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TTrainTariffInfoDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});
    Dumper_->Dump();
    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TTrainTariffInfo>{CreateModel()}));
}
