#include "transport_model_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TTransportModelSelectQuery::TTransportModelSelectQuery()
            : TSelectQuery("www_transportmodel", false)
            , IdField(AddField("id"))
            , TitleField(AddField("title"))
            , TitleEnField(AddField("title_en"))
            , TransportTypeIdField(AddField("t_type_id"))
            , TemplatePageField(AddField("template_page"))
            , CodeField(AddField("code"))
            , TtxField(AddField("ttx"))
            , DescriptionField(AddField("descr"))
            , BackgroundField(AddField("background"))
            , ImageField(AddField("img"))
            , ProducerIdField(AddField("producer_id"))
            , CodeEnField(AddField("code_en"))
            , IsCargoField(AddField("is_cargo"))
            , TransportSubtypeIdField(AddField("t_subtype_id"))
            , IsPropellerFlightField(AddField("is_propeller_flight"))
            , PlaneBodyTypeField(AddField("plane_body_type"))
        {
        }

        TTransportModelDumper::TTransportModelDumper(
            NRasp::NDumper::IFetcher& fetcher,
            IObjectWriter<NData::TTransportModel>& writer,
            TVehicleProducerProvider& vehicleProducerProvider)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
            , VehicleProducerProvider_(vehicleProducerProvider)
        {
        }

        TSet<i32>
        TTransportModelDumper::Dump() {
            INFO_LOG << "Run the transport models dumper" << Endl;

            VehicleProducerProvider_.Init();

            Fetcher_.InitQuery(Query.Str());

            TSet<i32> transportModelIds;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                const i32 id = ParseId(row[Query.IdField]);

                TTransportModel record;
                record.SetId(id);
                record.SetTitle(row[Query.TitleField]);
                record.SetTitleEn(row[Query.TitleEnField]);
                record.SetTemplatePage(row[Query.TemplatePageField]);
                record.SetCode(row[Query.CodeField]);
                record.SetTtx(row[Query.TtxField]);
                record.SetDescription(row[Query.DescriptionField]);
                record.SetBackground(row[Query.BackgroundField]);
                record.SetImage(row[Query.ImageField]);
                record.SetProducerId(ParseI32(row[Query.ProducerIdField]));
                record.SetCodeEn(row[Query.CodeEnField]);
                record.SetCargo(ParseBool(row[Query.IsCargoField]));
                record.SetTransportSubtypeId(ParseI32(row[Query.TransportSubtypeIdField]));
                record.SetPropellerFlight(ParseBool(row[Query.IsPropellerFlightField]));
                record.SetPlaneBodyType(row[Query.PlaneBodyTypeField]);

                record.SetProducerTitle(VehicleProducerProvider_.GetVehicleProducerTitle(record.GetProducerId()));

                {
                    const auto transportTypeId = ParseId(row[Query.TransportTypeIdField]);
                    if (!TTransport_EType_IsValid(transportTypeId)) {
                        WARNING_LOG << "SKIP TTransportModel: Can not find transportTypeId with id [" <<
                            transportTypeId << "] for the transport model with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetTransportType(
                        static_cast<TTransport::EType>(transportTypeId));
                }

                transportModelIds.insert(id);
                Writer_.Write(record);
            };

            if (transportModelIds.empty()) {
                ythrow yexception() << "Transport model dumper has no records.";
            }
            INFO_LOG << "The transport model dumper has dumped. Total count of transport models is " << transportModelIds.size() << Endl;

            return transportModelIds;
        }
    }
}
