#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/vehicle_producer_provider/vehicle_producer_provider.h>

#include <travel/proto/dicts/rasp/transport.pb.h>
#include <travel/proto/dicts/rasp/transport_model.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/hash.h>
#include <util/generic/set.h>

#include <regex>

namespace NRasp {
    namespace NDumper {
        class TTransportModelSelectQuery: public TSelectQuery {
        public:
            TTransportModelSelectQuery();

        public:
            const i32 IdField;
            const i32 TitleField;
            const i32 TitleEnField;
            const i32 TransportTypeIdField;
            const i32 TemplatePageField;
            const i32 CodeField;
            const i32 TtxField;
            const i32 DescriptionField;
            const i32 BackgroundField;
            const i32 ImageField;
            const i32 ProducerIdField;
            const i32 CodeEnField;
            const i32 IsCargoField;
            const i32 TransportSubtypeIdField;
            const i32 IsPropellerFlightField;
            const i32 PlaneBodyTypeField;
        };

        class TTransportModelDumper {
        public:
            TTransportModelDumper(
                NRasp::NDumper::IFetcher& fetcher,
                IObjectWriter<NData::TTransportModel>& writer,
                TVehicleProducerProvider& vehicleProducerProvider);
            TSet<i32> Dump();

        public:
            const TTransportModelSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TTransportModel>& Writer_;
            TVehicleProducerProvider& VehicleProducerProvider_;
        };
    }
}
