#include "transport_model_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TTransportModelDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TTransportModelDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST(TestUnknownTransportType);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeFetcher VehicleProducerFetcher_;
    TFakeObjectWriter<TTransportModel> ObjectWriter_;
    THolder<TVehicleProducerProvider> VehicleProducerProvider_;
    THolder<TTransportModelDumper> Dumper_;

    const i32 DefaultId_ = 999;

public:
    void SetUp() override {
        VehicleProducerFetcher_ = {};
        VehicleProducerFetcher_.Add({CreateVehicleProducerRow()});
        VehicleProducerProvider_ = MakeHolder<TVehicleProducerProvider>(VehicleProducerFetcher_);

        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TTransportModel>();
        Dumper_ = MakeHolder<TTransportModelDumper>(Fetcher_, ObjectWriter_, *VehicleProducerProvider_.Get());
    }

    TVector<TString> CreateRow() {
        return {
            ToString(DefaultId_),              // id
            "title_value",                     // title
            "title_en_value",                  // title_en
            "2",                               // transport_type
            "template_page_value",             // template_page
            "code_value",                      // code
            "ttx_value",                       // ttx
            "descr_value",                     // description
            "background_value",                // background
            "image_value",                     // image
            "11",                              // producer_id
            "code_en",                         // code_en
            "0",                               // is_cargo
            "7",                               // transport_subtype_id
            "0",                               // is_propeller_flight
            "wide",                            // plane_body_type
        };
    }

    static TVector<TString> CreateVehicleProducerRow() {
        return {
            "11",              // id
            "Сухой",           // title
        };
    }

    TTransportModel CreateModel() {
        TTransportModel record;
        record.SetId(DefaultId_);
        record.SetTitle("title_value");
        record.SetTitleEn("title_en_value");
        record.SetTransportType(TTransport::TYPE_PLANE);
        record.SetTemplatePage("template_page_value");
        record.SetCode("code_value");
        record.SetTtx("ttx_value");
        record.SetDescription("descr_value");
        record.SetBackground("background_value");
        record.SetImage("image_value");
        record.SetProducerId(11);
        record.SetProducerTitle("Сухой");
        record.SetCodeEn("code_en");
        record.SetTransportSubtypeId(7);
        record.SetPlaneBodyType("wide");

        return record;
    }
    void TestEmpty();
    void TestOneRecord();
    void TestUnknownTransportType();
};

UNIT_TEST_SUITE_REGISTRATION(TTransportModelDumperTest);

void TTransportModelDumperTest::TestEmpty() {
    Fetcher_.Add({});
    UNIT_ASSERT_EXCEPTION(Dumper_->Dump().size(), yexception);
}

void TTransportModelDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    UNIT_ASSERT_EQUAL(Dumper_->Dump(), TSet<i32>{DefaultId_});
    UNIT_ASSERT_STRINGS_EQUAL(ToJson(ObjectWriter_.GetResult()), ToJson(TVector<TTransportModel>{CreateModel()}));
}

void TTransportModelDumperTest::TestUnknownTransportType() {
    auto r = CreateRow();
    r[Dumper_->Query.TransportTypeIdField] = "666";
    Fetcher_.Add({r, CreateRow()});

    UNIT_ASSERT_EQUAL(Dumper_->Dump(), TSet<i32>{DefaultId_});
    UNIT_ASSERT_STRINGS_EQUAL(ToJson(ObjectWriter_.GetResult()), ToJson(TVector<TTransportModel>{CreateModel()}));
}
