#include "fake_fetcher.h"

namespace NRasp {
    namespace NDumper {
        TFakeFetcher::TFakeFetcher()
            : InitQueryCountCalled_(0)
            , GetNextCountCalled_(0)
        {
        }

        void TFakeFetcher::Reset() {
            Queries_.clear();
            CurrentPack_.clear();
            Packs_.clear();

            InitQueryCountCalled_ = 0;
            GetNextCountCalled_ = 0;
        }

        void TFakeFetcher::Add(TList<TVector<TString>> pack) {
            Packs_.push(pack);
        }

        void TFakeFetcher::InitQuery(const TString& query) {
            ++InitQueryCountCalled_;
            Queries_.push_back(query);

            CurrentPack_ = Packs_.front();
            Packs_.pop();
        }

        bool TFakeFetcher::GetNext(TVector<TString>* row) {
            if (Queries_.empty()) {
                ythrow TInitQueryRequiredError();
            }

            ++GetNextCountCalled_;
            if (CurrentPack_.empty()) {
                return false;
            }

            if (row->ysize() != CurrentPack_.front().ysize()) {
                ythrow TIncorectBufferSizeError() << "expected " << row->ysize() << " got " << CurrentPack_.front().ysize();
            }

            for (yssize_t i = 0; i < CurrentPack_.front().ysize(); ++i) {
                (*row)[i] = CurrentPack_.front()[i];
            }
            CurrentPack_.pop_front();
            return true;
        }

        const TVector<TString>& TFakeFetcher::GetQueries() const {
            return Queries_;
        }

        i32 TFakeFetcher::GetInitQueryCountCalled() const {
            return InitQueryCountCalled_;
        }

        i32 TFakeFetcher::GetNextCountCalled() const {
            return GetNextCountCalled_;
        }
    }
}
