#pragma once

#include "fetcher.h"

#include <util/generic/list.h>
#include <util/generic/queue.h>
#include <util/generic/yexception.h>

namespace NRasp {
    namespace NDumper {
        class TInitQueryRequiredError: public yexception {};
        class TReInitQueryError: public yexception {};
        class TIncorectBufferSizeError: public yexception {};

        class TFakeFetcher: public NRasp::NDumper::IFetcher {
        public:
            TFakeFetcher();

            void InitQuery(const TString& query) override;
            bool GetNext(TVector<TString>* row) override;

            void Reset();
            void Add(TList<TVector<TString>> pack);

        public:
            const TVector<TString>& GetQueries() const;

            i32 GetInitQueryCountCalled() const;

            i32 GetNextCountCalled() const;

        private:
            TVector<TString> Queries_;
            TQueue<TList<TVector<TString>>> Packs_;
            TList<TVector<TString>> CurrentPack_;
            i32 InitQueryCountCalled_;
            i32 GetNextCountCalled_;
        };
    }
}
