#include "fake_fetcher.h"

#include <library/cpp/testing/unittest/registar.h>
#include <memory>

using namespace NRasp::NDumper;

Y_UNIT_TEST_SUITE(FakeFetcher){
    Y_UNIT_TEST(Constructor){
        TFakeFetcher fetcher;

UNIT_ASSERT_EQUAL(fetcher.GetQueries(), TVector<TString>());
UNIT_ASSERT_EQUAL(fetcher.GetInitQueryCountCalled(), 0);
UNIT_ASSERT_EQUAL(fetcher.GetNextCountCalled(), 0);
}

Y_UNIT_TEST(InitQuery) {
    TFakeFetcher fetcher;
    fetcher.Add({});
    fetcher.InitQuery("select 1;");

    UNIT_ASSERT_EQUAL(fetcher.GetQueries(), TVector<TString>{"select 1;"});
    UNIT_ASSERT_EQUAL(fetcher.GetInitQueryCountCalled(), 1);
    UNIT_ASSERT_EQUAL(fetcher.GetNextCountCalled(), 0);
}

Y_UNIT_TEST(UseGetNextBeforeInitQuery) {
    TFakeFetcher fetcher;
    TVector<TString> buffer;
    UNIT_CHECK_GENERATED_EXCEPTION_C(fetcher.GetNext(&buffer), TInitQueryRequiredError, "AAA");
}
Y_UNIT_TEST(BufferAndRowHasDifferentSize) {
    TFakeFetcher fetcher;
    fetcher.Add(TList<TVector<TString>>{{"1", "msk"}, {"2", "ekb"}});
    TVector<TString> buffer(100);

    fetcher.InitQuery("select id, code from settlements;");
    UNIT_CHECK_GENERATED_EXCEPTION_C(fetcher.GetNext(&buffer), TIncorectBufferSizeError, "TIncorectBufferSizeError");
}

Y_UNIT_TEST(FetchAll) {
    TVector<TString> buffer(2);
    TFakeFetcher fetcher;
    fetcher.Add(TList<TVector<TString>>{{"1", "msk"}, {"2", "ekb"}});

    fetcher.InitQuery("select id, code from settlements;");
    UNIT_ASSERT_EQUAL(fetcher.GetQueries(), TVector<TString>{"select id, code from settlements;"});
    UNIT_ASSERT_EQUAL(fetcher.GetInitQueryCountCalled(), 1);
    UNIT_ASSERT_EQUAL(fetcher.GetNextCountCalled(), 0);

    {
        bool hasNext = fetcher.GetNext(&buffer);
        UNIT_ASSERT_EQUAL(fetcher.GetQueries(), TVector<TString>{"select id, code from settlements;"});
        UNIT_ASSERT_EQUAL(fetcher.GetInitQueryCountCalled(), 1);
        UNIT_ASSERT_EQUAL(fetcher.GetNextCountCalled(), 1);
        UNIT_ASSERT_EQUAL(hasNext, true);
        UNIT_ASSERT_EQUAL(buffer, TVector<TString>({"1", "msk"}));
    }

    {
        bool hasNext = fetcher.GetNext(&buffer);
        UNIT_ASSERT_EQUAL(fetcher.GetQueries(), TVector<TString>{"select id, code from settlements;"});
        UNIT_ASSERT_EQUAL(fetcher.GetInitQueryCountCalled(), 1);
        UNIT_ASSERT_EQUAL(fetcher.GetNextCountCalled(), 2);
        UNIT_ASSERT_EQUAL(hasNext, true);
        UNIT_ASSERT_EQUAL(buffer, TVector<TString>({"2", "ekb"}));
    }
    {
        bool hasNext = fetcher.GetNext(&buffer);
        UNIT_ASSERT_EQUAL(fetcher.GetQueries(), TVector<TString>{"select id, code from settlements;"});
        UNIT_ASSERT_EQUAL(fetcher.GetInitQueryCountCalled(), 1);
        UNIT_ASSERT_EQUAL(fetcher.GetNextCountCalled(), 3);
        UNIT_ASSERT_EQUAL(hasNext, false);
    }
}
}
;
