#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NRasp {
    namespace NDumper {
        class IFetcher {
        public:
            virtual void InitQuery(const TString& sql) = 0;
            virtual bool GetNext(TVector<TString>* row) = 0;
            virtual ~IFetcher(){};
        };

        class IHttpFetcher {
        public:
            virtual void InitQuery(const TString& url) = 0;
            virtual i32 GetData(TString& data) = 0;
            virtual ~IHttpFetcher() {};
        };
    }
}
