#include "http_fetcher.h"

using namespace NHttp;

namespace NRasp {
    namespace NDumper {
        THttpFetcher::THttpFetcher(const TString& oAuthToken) {
            Options_ = TFetchOptions().SetOAuthToken(oAuthToken);
        }

        void THttpFetcher::InitQuery(const TString& url) {
            Query_ = TFetchQuery(url, Options_);
            INFO_LOG << Query_.GetUrl() << Endl;
        }

        i32 THttpFetcher::GetData(TString& data) {
            auto result = Fetch(Query_);
            data = result->Data;
            INFO_LOG << "Fetched symbols: " << data.size() << Endl;

            return result->Code;
        }

        void TFakeHttpFetcher::InitQuery(const TString& url) {
            (void)url;
        }

        i32 TFakeHttpFetcher::GetData(TString& data) {
            data = Data_;
            return 200;
        }
    }
}
