#pragma once

#include "fetcher.h"

#include <library/cpp/http/client/client.h>
#include <library/cpp/logger/global/global.h>

namespace NRasp {
    namespace NDumper {
        class THttpFetcher : public IHttpFetcher {
        public:
            THttpFetcher(const TString& oAuthToken);
            virtual void InitQuery(const TString& url) override;
            virtual i32 GetData(TString& data) override;

        private:
            NHttp::TFetchOptions Options_;
            NHttp::TFetchQuery Query_;
        };

        class TFakeHttpFetcher : public IHttpFetcher {
        public:
            TFakeHttpFetcher() {};
            virtual void InitQuery(const TString& url) override;
            virtual i32 GetData(TString& data) override;
            void SetData(TString data) { Data_ = data; };
        private:
            TString Data_;
        };
    }
}
