#include "mysql_fetcher.h"
#include "util/generic/maybe.h"
#include <library/cpp/logger/global/global.h>

namespace NRasp {
    namespace NDumper {
        TMySqlFetcher::TMySqlFetcher(const TMySqlConfig& config)
            : DataBase_()
            , Config_(config)
            , SelectResult_(nullptr)
            , ColumnsCount_(0)
        {
            Configure_();
            Connect_();
        }

        TMySqlFetcher::~TMySqlFetcher() {
            mysql_close(&DataBase_);
        }

        void TMySqlFetcher::Configure_() {
            if (!mysql_init(&DataBase_)) {
                ythrow yexception() << "mysql_init() failed with error: " << mysql_error(&DataBase_);
            }
            mysql_options(&DataBase_, MYSQL_SET_CHARSET_NAME, (void*)"utf8");
        }

        void TMySqlFetcher::Connect_() {
            if (!mysql_real_connect(
                    &DataBase_,
                    Config_.host.c_str(),
                    Config_.user.c_str(),
                    Config_.passport.c_str(),
                    Config_.db.c_str(),
                    0, nullptr, 0))
            {
                ythrow yexception() << "mysql_real_connect() failed with error: " << mysql_error(&DataBase_);
            }
        }

        void TMySqlFetcher::InitQuery(const TString& sql) {
            INFO_LOG << sql << Endl;
            auto status = mysql_query(&DataBase_, sql.c_str());
            if (status != 0) {
                ythrow yexception() << "mysql_query() failed with error: " << mysql_error(&DataBase_);
            }

            SelectResult_.Reset(new TMySqlSelectHolder(&DataBase_));
            ColumnsCount_ = mysql_num_fields(&SelectResult_.Get()->Get());
        }

        bool TMySqlFetcher::GetNext(TVector<TString>* out) {
            auto row = mysql_fetch_row(&SelectResult_.Get()->Get());
            if (row == nullptr) {
                return false;
            }
            auto lengths = mysql_fetch_lengths(&SelectResult_.Get()->Get());

            out->resize(ColumnsCount_);
            for (size_t i = 0; i < ColumnsCount_; ++i) {
                (*out)[i] = TString(row[i], lengths[i]);
            }

            return true;
        }
    }
}
