#pragma once

#include "fetcher.h"
#include "mysql_helpers.h"
#include "util/generic/maybe.h"

namespace NRasp {
    namespace NDumper {
        class TMySqlFetcher: public IFetcher {
        public:
            TMySqlFetcher(const NRasp::NDumper::TMySqlConfig& config);
            ~TMySqlFetcher();

            virtual void InitQuery(const TString& sql) override;
            virtual bool GetNext(TVector<TString>* row) override;

        private:
            void Configure_();
            void Connect_();

        private:
            MYSQL DataBase_;
            const NRasp::NDumper::TMySqlConfig& Config_;
            THolder<NRasp::NDumper::TMySqlSelectHolder> SelectResult_;
            size_t ColumnsCount_;
        };
    }
}
